source("functions.R")

clotting <- data.frame(
u = c(5,10,15,20,30,40,60,80,100),
lot1 = c(118,58,42,35,27,25,21,19,18),
lot2 = c(69,35,26,21,18,16,13,12,12))
attach(clotting)

y<-c(clotting[,2],clotting[,3]); w<-y; x<-w #respuesta
x1<-rep(log(clotting[,1]),2)
x2<-c(rep(0,9),rep(1,9))
x3<-x1*x2
X<-model.matrix(~x1+x2+x3)
rho<-c(0.1,0.25,0.5,0.75,0.9)

aux1<-as.vector(AnalisisDescriptivo(y))
aux2<-as.vector(AnalisisDescriptivo(split(y,x2)$"0"))
aux3<-as.vector(AnalisisDescriptivo(split(y,x2)$"1"))

#########################
#### Table 6 ############
#########################
aa<-t(cbind(aux1,aux2,aux3))
colnames(aa)<-c("mean", "s.d.", "median", "IQ range", "min", "max", "skewness", "kurtosis")
rownames(aa)<-c("Global time", "time0", "time1")
aa


#########################
#### Figure 4 ###########
#########################
par(mai = c(0.85,0.85,0.05,0.05)) # Margins: inf, left, sup and right
plot(x1, y, col="white",las=1, xlab="lconc", ylab="time", cex.lab=1.8,
	cex.axis=1.8, ylim=c(0,120))
points(split(x1,x2)$"0", split(y,x2)$"0", pch=3, lwd=2, cex=1.8)
points(split(x1,x2)$"1", split(y,x2)$"1", pch=1, lwd=2, cex=1.8)
legend("topright", c("lot=0", "lot=1"), lwd=2, pch=c(3,1), bty="n", lty=NA,
	cex=1.8)




a<-c()
a[[1]]<-REPM.aplicacion.3.cov(w,x1,x2,x3,rho=0.1,psi.ini=c(0,0,0,0,0),KS=TRUE)[c(3,4)]
a[[2]]<-REPM.aplicacion.3.cov(w,x1,x2,x3,rho=0.25,psi.ini=c(0,1,0,0,0),KS=TRUE)[c(3,4)]
a[[3]]<-REPM.aplicacion.3.cov(w,x1,x2,x3,rho=0.5,psi.ini=c(1,1,9,1,1),KS=TRUE)[c(3,4)]
a[[4]]<-REPM.aplicacion.3.cov(w,x1,x2,x3,rho=0.75,psi.ini=c(1,1,7,0,1),KS=TRUE)[c(3,4)]
a[[5]]<-REPM.aplicacion.3.cov(w,x1,x2,x3,rho=0.9,psi.ini=c(1,1,7,0,1),KS=TRUE)[c(3,4)]
aux.REPM<-c(); aux.REPM[[2]][1]<-NA
for(j in 1:2)
{
	for(i in 1:5)
	{
	aux.REPM[[j]][i]<-a[[i]][[j]]
	}
}

aux.SKL<-p.AIC.SKD(w,X,rho=c(0.1,0.25,0.5,0.75,0.9),dist="laplace")


aux.SKT<-p.AIC.SKD(w,X,rho=c(0.1,0.25,0.5,0.75,0.9),dist="t")


q.seq=c(0.1,0.25,0.5,0.75,0.9)
kkss=c()
Z=t(model.matrix(~x1+x2+x3))
AIC.SCG=c()
for(i in 1:length(q.seq))
{
q=q.seq[i];r=nrow(Z)
phi=uniroot(solve.phi,lower=0.00001,upper=10,q=q)$root
aux.cov=optim(c(rep(median(w),r+2)),logvero.SCG.cov,x=w,Z=Z,phi=phi,method="BFGS", control=list(maxit=10000))
#aux.cov=optim(c(rep(1,r+2)),logvero.SCG.cov,x=w,Z=Z,phi=phi,method="BFGS", control=list(maxit=10000))
par=c(aux.cov$par[1:r],exp(aux.cov$par[(r+1):(r+2)]))#PARAMETROS ESTIMADOS	
AIC.SCG[i]=2*aux.cov$value+2*(r+2)

mu=t(Z)%*%aux.cov$par[1:r]
sigma=exp(aux.cov$par[r+1])
lambda=exp(aux.cov$par[r+2])

acum<-pgamma(-log(1/2-(1/pi)*atan(lambda*sinh((x-mu)/sigma))),shape=phi)
res.q<-qnorm(acum)
kkss[i]<-ks.test(res.q,"pnorm")$p.value

}

#########################
#### Table 7 ############
#########################
#AIC
round(data.frame(SKT=aux.SKT$AIC, SKL=aux.SKL$AIC, GSC=AIC.SCG, REPM=aux.REPM[[1]]),3)
#KS
round(data.frame(SKT=aux.SKT$'p-value', SKL=aux.SKL$'p-value', GSC=round(kkss,4), REPM=aux.REPM[[2]]),3)




psi.ini<-cbind(c(0,0,0,0,0),c(0,1,0,0,0),c(0,1,0,0,0),c(1,1,9,1,1),c(1,1,9,1,1),c(1,1,7,0,1),c(1,1,7,0,1),c(1,1,7,0,1),c(1,1,9,1,1))
x1<-X[,2]; x2<-X[,3]; x3<-X[,4]; rho<-seq(0.1,0.9,0.1)
F0<-c(); F1<-c(); F2<-c(); F3<-c(); sd0<-c(); sd1<-c(); sd2<-c(); sd3<-c()
for(i in 1:length(rho))
{
	aux<-REPM.aplicacion.3.cov(w,x1,x2,x3,rho[i],psi.ini[,i],KS=TRUE)
	F0[i]<-round(aux[[1]][2],3); F1[i]<-round(aux[[1]][3],3)
	F2[i]<-round(aux[[1]][4],3); F3[i]<-round(aux[[1]][5],3)
	sd0[i]<-round(aux[[2]][2],3); sd1[i]<-round(aux[[2]][3],3) 
	sd2[i]<-round(aux[[2]][4],3); sd3[i]<-round(aux[[2]][5],3)
}
F0; F1; F2; F3
sd0; sd1; sd2; sd3

L0<-F0 -sd0*1.96; U0<-F0 +sd0*1.96
L1<-F1 -sd1*1.96; U1<-F1 +sd1*1.96
L2<-F2 -sd2*1.96; U2<-F2 +sd2*1.96
L3<-F3 -sd3*1.96; U3<-F3 +sd3*1.96

#par(mfrow=c(2,2))

####################
## 	Figure 5 	##
####################

##Figure 5a
plot(rho,F0,pch=19,ylim=c(1,9),xlab=expression(rho),ylab=expression(tau[0](rho)),
cex.lab=1.6, cex.axis=1.6)
lines(rho,F0,type="l",lty=2, lwd=4)

polygon(c(rho,rev(rho)),c(L0,rev(U0)),col = "grey75", border = T)
points(rho,F0,pch=19, lwd=5)
lines(rho,F0,type="l",lty=4)


##Figure 5b
plot(rho,F1,pch=19,ylim=c(-1,0.5),xlab=expression(rho),ylab=expression(tau[1](rho)),
cex.lab=1.6, cex.axis=1.6)
lines(rho,F1,type="l",lty=2)

polygon(c(rho,rev(rho)),c(L1,rev(U1)),col = "grey75", border = T)
points(rho,F1,pch=19, lwd=5)
lines(rho,F1,type="l",lty=2, lwd=4)


##Figure 5c
plot(rho,F2,pch=19,ylim=c(-3,3),xlab=expression(rho),ylab=expression(tau[2](rho)),
cex.lab=1.6, cex.axis=1.6)
lines(rho,F2,type="l",lty=2)

polygon(c(rho,rev(rho)),c(L2,rev(U2)),col = "grey75", border = T)
points(rho,F2,pch=19, lwd=5)
lines(rho,F2,type="l",lty=2, lwd=4)


##Figure 5d
plot(rho,F3,pch=19,ylim=c(-1,1),xlab=expression(rho),ylab=expression(tau[3](rho)),
cex.lab=1.6, cex.axis=1.6)
lines(rho,F3,type="l",lty=2)

polygon(c(rho,rev(rho)),c(L3,rev(U3)),col = "grey75", border = T)
points(rho,F3,pch=19, lwd=5)
lines(rho,F3,type="l",lty=2, lwd=4)


#####################
## 	Figure 6 	 ##
#####################

##Figure 6a
rho<-0.5; q<-rho
x1<-2.302585; x2<-0; x3<-x1*x2

fu<-function(phi,q) {pgamma(log(2),phi) -q}; phi<-uniroot(fu,q=q,c(0,10))$root
theta.GSC<-c(par[1] +par[2]*x1 +par[3]*x2 + par[4]*x3, par[5], par[6], phi)
curve(dSCG(x,theta.GSC,log=FALSE),xlim=c(0,100),lwd=3, lty=2,ylim=c(0,0.2),
xlab="time",ylab="density",main=paste(expression(q),"=",rho),cex.main=2, cex.lab=1.6,
cex.axis=1.6)

aa<-lqr(w, x=X, p = rho, dist = "laplace")
theta.SKL<-c(aa$beta[1]+ aa$beta[2]*x1 +aa$beta[3]*x2 +aa$beta[4]*x3, aa$sigma)
curve(dSKD(x, mu=theta.SKL[1], sigma=theta.SKL[2], p=rho, dist="laplace"),lwd=3,lty=3, add=T)

aa<-lqr(w, x=X, p = rho, dist = "t")
theta.SKL<-c(aa$beta[1]+ aa$beta[2]*x1 +aa$beta[3]*x2 +aa$beta[4]*x3, aa$sigma,aa$nu)
curve(dSKD(x, mu=theta.SKL[1], sigma=theta.SKL[2], nu=theta.SKL[3], p=rho, dist="t"),lwd=3,lty=4, add=T)

theta.REPM<-REPM.aplicacion.3.cov(w,X[,2],X[,3],X[,4],rho,c(1,1,9,1,1),KS=T)[[1]]
beta<-theta.REPM[1]; mu<-exp(theta.REPM[2] +theta.REPM[3]*x1 +theta.REPM[4]*x2 +theta.REPM[4]*x2)
psi<-mu^(beta); gamma<-log(rho)/log(0.199)
curve.EPM(psi,beta,gamma,lwd=3,add=T)

a<-c("REPM","GSC","SKL", "SKT")
legend("topright",a,lty=c(1,2,3,4),bty="n", cex=1.6, lwd=3)


##Figure 6b

rho<-0.75; q<-rho
x1<-2.302585; x2<-0; x3<-x1*x2

fu<-function(phi,q) {pgamma(log(2),phi) -q}; phi<-uniroot(fu,q=q,c(0,10))$root
theta.GSC<-c(par[1] +par[2]*x1 +par[3]*x2 + par[4]*x3, par[5], par[6], phi)
curve(dSCG(x,theta.GSC,log=FALSE),xlim=c(0,100),lwd=3, lty=2,ylim=c(0,0.2),
xlab="time",ylab="density",main=paste(expression(q),"=",rho),cex.main=2, cex.lab=1.6,
cex.axis=1.6)

aa<-lqr(w, x=X, p = rho, dist = "laplace")
theta.SKL<-c(aa$beta[1]+ aa$beta[2]*x1 +aa$beta[3]*x2 +aa$beta[4]*x3, aa$sigma)
curve(dSKD(x, mu=theta.SKL[1], sigma=theta.SKL[2], p=rho, dist="laplace"),lwd=3,lty=3, add=T)

aa<-lqr(w, x=X, p = rho, dist = "t")
theta.SKL<-c(aa$beta[1]+ aa$beta[2]*x1 +aa$beta[3]*x2 +aa$beta[4]*x3, aa$sigma,aa$nu)
curve(dSKD(x, mu=theta.SKL[1], sigma=theta.SKL[2], nu=theta.SKL[3], p=rho, dist="t"),lwd=3,lty=4, add=T)

theta.REPM<-REPM.aplicacion.3.cov(w,X[,2],X[,3],X[,4],rho,c(1,1,7,0,1),KS=T)[[1]]
beta<-theta.REPM[1]; mu<-exp(theta.REPM[2] +theta.REPM[3]*x1 +theta.REPM[4]*x2 +theta.REPM[4]*x2)
psi<-mu^(beta); gamma<-log(rho)/log(0.199)
curve.EPM(psi,beta,gamma,lwd=3,add=T)

a<-c("REPM","GSC","SKL", "SKT")
legend("topright",a,lty=c(1,2,3,4),bty="n", cex=1.6, lwd=3)



